<?php
// edgeupg.php - Fixed Gzip upload handler
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: *');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get parameters from headers or form data
    $filename = $_SERVER['HTTP_X_FILENAME'] ?? ($_POST['filename'] ?? 'uploaded_file.dat');
    $path = $_SERVER['HTTP_X_PATH'] ?? ($_POST['path'] ?? 'gzip-uploads');
    
    // Sanitize inputs
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '_', $filename);
    $path = preg_replace('/[^a-zA-Z0-9._-\/]/', '_', $path);
    
    // Create directory
    $baseDir = __DIR__ . '/files';
    $fullPath = $baseDir . '/' . $path;
    if (!is_dir($fullPath)) {
        mkdir($fullPath, 0777, true);
    }
    
    // Get the raw POST data
    $compressedData = file_get_contents('php://input');
    
    if (empty($compressedData)) {
        http_response_code(400);
        echo "Error: No data received";
        exit;
    }
    
    // Try different decompression methods
    $decompressedData = null;
    
    // Method 1: gzdecode (most common)
    if (function_exists('gzdecode')) {
        $decompressedData = gzdecode($compressedData);
    }
    
    // Method 2: gzinflate (alternative)
    if ($decompressedData === false && function_exists('gzinflate')) {
        $decompressedData = gzinflate($compressedData);
    }
    
    // Method 3: zlib decode
    if ($decompressedData === false && function_exists('zlib_decode')) {
        $decompressedData = zlib_decode($compressedData);
    }
    
    // Method 4: Try without decompression (maybe it's not compressed)
    if ($decompressedData === false) {
        $decompressedData = $compressedData;
    }
    
    if ($decompressedData === false) {
        http_response_code(400);
        echo "Error: All decompression methods failed";
        exit;
    }
    
    // Save the file
    $filePath = $fullPath . '/' . $filename;
    if (file_put_contents($filePath, $decompressedData)) {
        // FIXED: Use dynamic server URL instead of hardcoded
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        $publicUrl = "{$protocol}://{$host}/files/" . $path . "/" . urlencode($filename);
        echo $publicUrl;
    } else {
        http_response_code(500);
        echo "Error: Failed to save file";
    }
    
} else {
    http_response_code(405);
    echo "Method not allowed";
}
?>